{*

--------------------------------------------
---------   Looking to make edits?   -------
--------------------------------------------

You can edit your template without editing this file directly.

For more information about editing your template please refer to our full documentation below:

https://www.zomex.com/docs/whmcs-templates/

Feel free to contact Zomex if you run into any issues or have any questions.

--------------------------------------------

*}

{if $LANG.prosper_registerdomain_featuredtld_display || $LANG.prosper_registerdomain_domainpricing_display}

	<div class="domain-pricing">
	
		{if $LANG.prosper_registerdomain_featuredtld_display && $featuredTlds}
		
			{if $LANG.prosper_registerdomain_featuredtld_heading}
				<div class="headingstyle1" id="featured">
					<h2>{$LANG.prosper_registerdomain_featuredtld_heading}</h2>
				</div>
			{/if}		
		
	        <div class="featured-tlds-container">
	            <div class="row">
	                {foreach $featuredTlds as $num => $tldinfo}
	                    <div class="col-md-3 col-sm-4 col-6">
	                        <div class="featured-tld">
	                            <div class="img-container">
	                                <img src="{$BASE_PATH_IMG}/tld_logos/{$tldinfo.tldNoDots}.png">
	                            </div>
	                            <div class="price {$tldinfo.tldNoDots}">
	                                {if is_object($tldinfo.register)}
	                                    {$tldinfo.register->toPrefixed()}{if $tldinfo.period > 1}{lang key="orderForm.shortPerYears" years={$tldinfo.period}}{else}{lang key="orderForm.shortPerYear" years=''}{/if}
	                                {else}
	                                    {lang key="domainregnotavailable"}
	                                {/if}
	                            </div>
	                        </div>
	                    </div>
	                {/foreach}
	            </div>
	        </div>
	    
	    {/if}
	
	    {if !$loggedin && $currencies}
	        <form method="post" action="" class="float-right">
	            <select name="currency" class="form-control currency-selector" onchange="submit()">
	                <option>
	                    {lang key="changeCurrency"} ({$activeCurrency.prefix} {$activeCurrency.code})
	                </option>
	                {foreach $currencies as $currency}
	                    <option value="{$currency['id']}">
	                        {$currency['prefix']} {$currency['code']}
	                    </option>
	                {/foreach}
	            </select>
	        </form>
	    {/if}
	    
	    {if $LANG.prosper_registerdomain_domainpricing_display}
	    
			{if $LANG.prosper_registerdomain_domainpricing_heading}
				<div class="headingstyle1" id="pricing">
					<h2>{$LANG.prosper_registerdomain_domainpricing_heading}</h2>
				</div>
			{/if}
			
			{if $LANG.prosper_registerdomain_domainpricing_text}
				{$LANG.prosper_registerdomain_domainpricing_text}
			{/if}	
	
		    <div class="tld-filters">
		        {foreach $tldCategories as $category => $count}
		            <a href="#" data-category="{$category}" class="badge badge-secondary">{lang key="domainTldCategory.$category" defaultValue=$category} ({$count})</a>
		        {/foreach}
		    </div>
		
		    {include file="$template/includes/tablelist.tpl" tableName="DomainPricing" noOrdering=true}
		    <script>
		        jQuery(document).ready(function() {
		            var table = jQuery('#tableDomainPricing').show().DataTable();
		
		            {if $orderby == 'date'}
		                table.order(0, '{$sort}');
		            {elseif $orderby == 'subject'}
		                table.order(1, '{$sort}');
		            {/if}
		            table.draw();
		            jQuery('#tableLoading').hide();
		            jQuery('.tld-filters a').unbind();
		            jQuery('.tld-filters a').click(function(e) {
		                e.preventDefault();
		                if (jQuery(this).hasClass('badge-success')) {
		                    jQuery('#tableDomainPricing_wrapper input[type="search"]').val('').trigger('keyup');
		                    jQuery('.tld-filters a').removeClass('badge-success');
		                } else {
		                    jQuery('#tableDomainPricing_wrapper input[type="search"]').val(jQuery(this)
		                        .data('category'))
		                        .trigger('keyup');
		                    jQuery('.tld-filters a').removeClass('badge-success');
		                    jQuery(this).addClass('badge-success');
		                }
		            });
		        });
		    </script>
		
		    <div class="table-container clearfix overflow-auto">
		        <table class="table table-list hidden" id="tableDomainPricing">
		            <thead>
		            <tr>
		                <th>{lang key='domaintld'}</th>
		                <th>{lang key='category'}</th>
		                <th>{lang key='pricing.register'}</th>
		                <th>{lang key='pricing.transfer'}</th>
		                <th>{lang key='pricing.renewal'}</th>
		                <th>{lang key='gracePeriod'}</th>
		                <th>{lang key='redemptionPeriod'}</th>
		            </tr>
		            </thead>
		            <tbody>
		            {foreach $pricing as $extension => $data}
		                <tr>
		                    <td>
		                        {$extension}
		                        {if $data.group}
		                            <span class="tld-sale-group tld-sale-group-{$data.group}">
		                                {$data.group}!
		                            </span>
		                        {/if}
		                    </td>
		                    <td>
		                        {$data.categories[0]}
		                        <span class="w-hidden">
		                            {foreach $data.categories as $category}
		                                {$category}
		                            {/foreach}
		                        </span>
		                    </td>
		                    {foreach $data.register as $years => $price}
		                        <td>
		                            {if $price >= 0}
		                                {$price}<br>
		                                <small>{$years} {if $years > 1}{lang key="orderForm.years"}{else}{lang key="orderForm.year"}{/if}</small>
		                            {else}
		                                <small>{lang key="domainregnotavailable"}</small>
		                            {/if}
		                        </td>
		                        {break}
		                    {foreachelse}
		                        <td>-</td>
		                    {/foreach}
		                    {foreach $data.transfer as $years => $price}
		                        <td>
		                            {if $price >= 0}
		                                {$price}<br>
		                                <small>{$years} {if $years > 1}{lang key="orderForm.years"}{else}{lang key="orderForm.year"}{/if}</small>
		                            {else}
		                                <small>{lang key="domainregnotavailable"}</small>
		                            {/if}
		                        </td>
		                        {break}
		                    {foreachelse}
		                        <td>-</td>
		                    {/foreach}
		                    {foreach $data.renew as $years => $price}
		                        <td>
		                            {if $price >= 0}
		                                {$price}<br>
		                                <small>{$years} {if $years > 1}{lang key="orderForm.years"}{else}{lang key="orderForm.year"}{/if}</small>
		                            {else}
		                                <small>{lang key="domainregnotavailable"}</small>
		                            {/if}
		                        </td>
		                        {break}
		                    {foreachelse}
		                        <td>-</td>
		                    {/foreach}
		                    <td>
		                        {if is_null($data.grace_period)}
		                            -
		                        {else}
		                            {$data.grace_period.days} {lang key='domainrenewalsdays'}<br>
		                            <small>({$data.grace_period.price})</small>
		                        {/if}
		                    </td>
		                    <td>
		                        {if is_null($data.redemption_period)}
		                            -
		                        {else}
		                            {$data.redemption_period.days} {lang key='domainrenewalsdays'}<br>
		                            <small>({$data.redemption_period.price})</small>
		                        {/if}
		                    </td>
		                </tr>
		            {foreachelse}
		                <tr>
		                    <td colspan="7">{lang key="pricing.noExtensionsDefined"}</td>
		                </tr>
		            {/foreach}
		            </tbody>
		        </table>
		        <div class="text-center" id="tableLoading">
		            <p><i class="fas fa-spinner fa-spin"></i> {lang key='loading'}</p>
		        </div>
		    </div>
	    
	    {/if}
	
	</div>

{/if}

{if $LANG.prosper_registerdomain_features_display}

	{if $LANG.prosper_registerdomain_features_heading}
		<div class="headingstyle1" id="features">
			<h1>{$LANG.prosper_registerdomain_features_heading}</h1>
		</div>
	{/if}
	
	<div class="gridboxes1">
		
		{if $LANG.prosper_registerdomain_features_1_display}
		
			<div class="gridboxes1-box animate__animated animate__fadeInLeft wow{if $LANG.prosper_registerdomain_features_1_displayorder neq 0} displayorder{$LANG.prosper_registerdomain_features_1_displayorder}{/if}">
				
				{if $LANG.prosper_registerdomain_features_1_image}
				
					<div class="gridboxes1-image">
						{if $LANG.prosper_registerdomain_features_1_image_url}<a href="{$LANG.prosper_registerdomain_features_1_image_url}"{if $LANG.prosper_registerdomain_features_1_image_url_newwindow} target="_blank"{/if}>{/if}<img src="{$WEB_ROOT}/templates/{$template}/images/{$LANG.prosper_registerdomain_features_1_image}" alt="{$LANG.prosper_registerdomain_features_1_image_alt}" />{if $LANG.prosper_registerdomain_features_1_image_url}</a>{/if}
					</div>
				
				{/if}
				
				{if $LANG.prosper_registerdomain_features_1_heading}
				
					<h4 class="gridboxes1-heading">{$LANG.prosper_registerdomain_features_1_heading}</h4>
				
				{/if}
				
				{if $LANG.prosper_registerdomain_features_1_text}
				
					<div class="gridboxes1-text">
				
						{$LANG.prosper_registerdomain_features_1_text}
					
					</div><!-- .gridboxes1-text -->
				
				{/if}

				{if $LANG.prosper_registerdomain_features_1_button1_url || $LANG.prosper_registerdomain_features_1_button2_url}
					<div class="gridboxes1-buttons">
						{if $LANG.prosper_registerdomain_features_1_button1_url}<a href="{$LANG.prosper_registerdomain_features_1_button1_url}" class="button1 color2"{if $LANG.prosper_registerdomain_features_1_button1_url_newwindow} target="_blank"{/if}>{if $LANG.prosper_registerdomain_features_1_button1_icon}<i class="{$LANG.prosper_registerdomain_features_1_button1_icon}"></i>{/if}{$LANG.prosper_registerdomain_features_1_button1_text}</a>{/if}
						{if $LANG.prosper_registerdomain_features_1_button2_url}<a href="{$LANG.prosper_registerdomain_features_1_button2_url}" class="button1 color2"{if $LANG.prosper_registerdomain_features_1_button2_url_newwindow} target="_blank"{/if}>{if $LANG.prosper_registerdomain_features_1_button2_icon}<i class="{$LANG.prosper_registerdomain_features_1_button2_icon}"></i>{/if}{$LANG.prosper_registerdomain_features_1_button2_text}</a>{/if}							
					</div>
				{/if}					
				
			</div><!-- .gridboxes1-box -->
		
		{/if}
		
		{if $LANG.prosper_registerdomain_features_2_display}
		
			<div class="gridboxes1-box animate__animated animate__fadeInUp wow{if $LANG.prosper_registerdomain_features_2_displayorder neq 0} displayorder{$LANG.prosper_registerdomain_features_2_displayorder}{/if}">
				
				{if $LANG.prosper_registerdomain_features_2_image}
				
					<div class="gridboxes1-image">
						{if $LANG.prosper_registerdomain_features_2_image_url}<a href="{$LANG.prosper_registerdomain_features_2_image_url}"{if $LANG.prosper_registerdomain_features_2_image_url_newwindow} target="_blank"{/if}>{/if}<img src="{$WEB_ROOT}/templates/{$template}/images/{$LANG.prosper_registerdomain_features_2_image}" alt="{$LANG.prosper_registerdomain_features_2_image_alt}" />{if $LANG.prosper_registerdomain_features_2_image_url}</a>{/if}
					</div>
				
				{/if}
				
				{if $LANG.prosper_registerdomain_features_2_heading}
				
					<h4 class="gridboxes1-heading">{$LANG.prosper_registerdomain_features_2_heading}</h4>
				
				{/if}
				
				{if $LANG.prosper_registerdomain_features_2_text}
				
					<div class="gridboxes1-text">
				
						{$LANG.prosper_registerdomain_features_2_text}
					
					</div><!-- .gridboxes1-text -->
				
				{/if}

				{if $LANG.prosper_registerdomain_features_2_button1_url || $LANG.prosper_registerdomain_features_2_button2_url}
					<div class="gridboxes1-buttons">
						{if $LANG.prosper_registerdomain_features_2_button1_url}<a href="{$LANG.prosper_registerdomain_features_2_button1_url}" class="button1 color2"{if $LANG.prosper_registerdomain_features_2_button1_url_newwindow} target="_blank"{/if}>{if $LANG.prosper_registerdomain_features_2_button1_icon}<i class="{$LANG.prosper_registerdomain_features_2_button1_icon}"></i>{/if}{$LANG.prosper_registerdomain_features_2_button1_text}</a>{/if}
						{if $LANG.prosper_registerdomain_features_2_button2_url}<a href="{$LANG.prosper_registerdomain_features_2_button2_url}" class="button1 color2"{if $LANG.prosper_registerdomain_features_2_button2_url_newwindow} target="_blank"{/if}>{if $LANG.prosper_registerdomain_features_2_button2_icon}<i class="{$LANG.prosper_registerdomain_features_2_button2_icon}"></i>{/if}{$LANG.prosper_registerdomain_features_2_button2_text}</a>{/if}							
					</div>
				{/if}					
				
			</div><!-- .gridboxes1-box -->
		
		{/if}
		
		{if $LANG.prosper_registerdomain_features_3_display}
		
			<div class="gridboxes1-box animate__animated animate__fadeInRight wow{if $LANG.prosper_registerdomain_features_3_displayorder neq 0} displayorder{$LANG.prosper_registerdomain_features_3_displayorder}{/if}">
				
				{if $LANG.prosper_registerdomain_features_3_image}
				
					<div class="gridboxes1-image">
						{if $LANG.prosper_registerdomain_features_3_image_url}<a href="{$LANG.prosper_registerdomain_features_3_image_url}"{if $LANG.prosper_registerdomain_features_3_image_url_newwindow} target="_blank"{/if}>{/if}<img src="{$WEB_ROOT}/templates/{$template}/images/{$LANG.prosper_registerdomain_features_3_image}" alt="{$LANG.prosper_registerdomain_features_3_image_alt}" />{if $LANG.prosper_registerdomain_features_3_image_url}</a>{/if}
					</div>
				
				{/if}
				
				{if $LANG.prosper_registerdomain_features_3_heading}
				
					<h4 class="gridboxes1-heading">{$LANG.prosper_registerdomain_features_3_heading}</h4>
				
				{/if}
				
				{if $LANG.prosper_registerdomain_features_3_text}
				
					<div class="gridboxes1-text">
				
						{$LANG.prosper_registerdomain_features_3_text}
					
					</div><!-- .gridboxes1-text -->
				
				{/if}

				{if $LANG.prosper_registerdomain_features_3_button1_url || $LANG.prosper_registerdomain_features_3_button2_url}
					<div class="gridboxes1-buttons">
						{if $LANG.prosper_registerdomain_features_3_button1_url}<a href="{$LANG.prosper_registerdomain_features_3_button1_url}" class="button1 color2"{if $LANG.prosper_registerdomain_features_3_button1_url_newwindow} target="_blank"{/if}>{if $LANG.prosper_registerdomain_features_3_button1_icon}<i class="{$LANG.prosper_registerdomain_features_3_button1_icon}"></i>{/if}{$LANG.prosper_registerdomain_features_3_button1_text}</a>{/if}
						{if $LANG.prosper_registerdomain_features_3_button2_url}<a href="{$LANG.prosper_registerdomain_features_3_button2_url}" class="button1 color2"{if $LANG.prosper_registerdomain_features_3_button2_url_newwindow} target="_blank"{/if}>{if $LANG.prosper_registerdomain_features_3_button2_icon}<i class="{$LANG.prosper_registerdomain_features_3_button2_icon}"></i>{/if}{$LANG.prosper_registerdomain_features_3_button2_text}</a>{/if}							
					</div>
				{/if}					
				
			</div><!-- .gridboxes1-box -->
		
		{/if}
		
		{if $LANG.prosper_registerdomain_features_4_display}
		
			<div class="gridboxes1-box animate__animated animate__fadeInLeft wow{if $LANG.prosper_registerdomain_features_4_displayorder neq 0} displayorder{$LANG.prosper_registerdomain_features_4_displayorder}{/if}">
				
				{if $LANG.prosper_registerdomain_features_4_image}
				
					<div class="gridboxes1-image">
						{if $LANG.prosper_registerdomain_features_4_image_url}<a href="{$LANG.prosper_registerdomain_features_4_image_url}"{if $LANG.prosper_registerdomain_features_4_image_url_newwindow} target="_blank"{/if}>{/if}<img src="{$WEB_ROOT}/templates/{$template}/images/{$LANG.prosper_registerdomain_features_4_image}" alt="{$LANG.prosper_registerdomain_features_4_image_alt}" />{if $LANG.prosper_registerdomain_features_4_image_url}</a>{/if}
					</div>
				
				{/if}
				
				{if $LANG.prosper_registerdomain_features_4_heading}
				
					<h4 class="gridboxes1-heading">{$LANG.prosper_registerdomain_features_4_heading}</h4>
				
				{/if}
				
				{if $LANG.prosper_registerdomain_features_4_text}
				
					<div class="gridboxes1-text">
				
						{$LANG.prosper_registerdomain_features_4_text}
					
					</div><!-- .gridboxes1-text -->
				
				{/if}

				{if $LANG.prosper_registerdomain_features_4_button1_url || $LANG.prosper_registerdomain_features_4_button2_url}
					<div class="gridboxes1-buttons">
						{if $LANG.prosper_registerdomain_features_4_button1_url}<a href="{$LANG.prosper_registerdomain_features_4_button1_url}" class="button1 color2"{if $LANG.prosper_registerdomain_features_4_button1_url_newwindow} target="_blank"{/if}>{if $LANG.prosper_registerdomain_features_4_button1_icon}<i class="{$LANG.prosper_registerdomain_features_4_button1_icon}"></i>{/if}{$LANG.prosper_registerdomain_features_4_button1_text}</a>{/if}
						{if $LANG.prosper_registerdomain_features_4_button2_url}<a href="{$LANG.prosper_registerdomain_features_4_button2_url}" class="button1 color2"{if $LANG.prosper_registerdomain_features_4_button2_url_newwindow} target="_blank"{/if}>{if $LANG.prosper_registerdomain_features_4_button2_icon}<i class="{$LANG.prosper_registerdomain_features_4_button2_icon}"></i>{/if}{$LANG.prosper_registerdomain_features_4_button2_text}</a>{/if}							
					</div>
				{/if}					
				
			</div><!-- .gridboxes1-box -->
		
		{/if}
		
		{if $LANG.prosper_registerdomain_features_5_display}
		
			<div class="gridboxes1-box animate__animated animate__fadeInUp wow{if $LANG.prosper_registerdomain_features_5_displayorder neq 0} displayorder{$LANG.prosper_registerdomain_features_5_displayorder}{/if}">
				
				{if $LANG.prosper_registerdomain_features_5_image}
				
					<div class="gridboxes1-image">
						{if $LANG.prosper_registerdomain_features_5_image_url}<a href="{$LANG.prosper_registerdomain_features_5_image_url}"{if $LANG.prosper_registerdomain_features_5_image_url_newwindow} target="_blank"{/if}>{/if}<img src="{$WEB_ROOT}/templates/{$template}/images/{$LANG.prosper_registerdomain_features_5_image}" alt="{$LANG.prosper_registerdomain_features_5_image_alt}" />{if $LANG.prosper_registerdomain_features_5_image_url}</a>{/if}
					</div>
				
				{/if}
				
				{if $LANG.prosper_registerdomain_features_5_heading}
				
					<h4 class="gridboxes1-heading">{$LANG.prosper_registerdomain_features_5_heading}</h4>
				
				{/if}
				
				{if $LANG.prosper_registerdomain_features_5_text}
				
					<div class="gridboxes1-text">
				
						{$LANG.prosper_registerdomain_features_5_text}
					
					</div><!-- .gridboxes1-text -->
				
				{/if}

				{if $LANG.prosper_registerdomain_features_5_button1_url || $LANG.prosper_registerdomain_features_5_button2_url}
					<div class="gridboxes1-buttons">
						{if $LANG.prosper_registerdomain_features_5_button1_url}<a href="{$LANG.prosper_registerdomain_features_5_button1_url}" class="button1 color2"{if $LANG.prosper_registerdomain_features_5_button1_url_newwindow} target="_blank"{/if}>{if $LANG.prosper_registerdomain_features_5_button1_icon}<i class="{$LANG.prosper_registerdomain_features_5_button1_icon}"></i>{/if}{$LANG.prosper_registerdomain_features_5_button1_text}</a>{/if}
						{if $LANG.prosper_registerdomain_features_5_button2_url}<a href="{$LANG.prosper_registerdomain_features_5_button2_url}" class="button1 color2"{if $LANG.prosper_registerdomain_features_5_button2_url_newwindow} target="_blank"{/if}>{if $LANG.prosper_registerdomain_features_5_button2_icon}<i class="{$LANG.prosper_registerdomain_features_5_button2_icon}"></i>{/if}{$LANG.prosper_registerdomain_features_5_button2_text}</a>{/if}							
					</div>
				{/if}					
				
			</div><!-- .gridboxes1-box -->
		
		{/if}
		
		{if $LANG.prosper_registerdomain_features_6_display}
		
			<div class="gridboxes1-box animate__animated animate__fadeInRight wow{if $LANG.prosper_registerdomain_features_6_displayorder neq 0} displayorder{$LANG.prosper_registerdomain_features_6_displayorder}{/if}">
				
				{if $LANG.prosper_registerdomain_features_6_image}
				
					<div class="gridboxes1-image">
						{if $LANG.prosper_registerdomain_features_6_image_url}<a href="{$LANG.prosper_registerdomain_features_6_image_url}"{if $LANG.prosper_registerdomain_features_6_image_url_newwindow} target="_blank"{/if}>{/if}<img src="{$WEB_ROOT}/templates/{$template}/images/{$LANG.prosper_registerdomain_features_6_image}" alt="{$LANG.prosper_registerdomain_features_6_image_alt}" />{if $LANG.prosper_registerdomain_features_6_image_url}</a>{/if}
					</div>
				
				{/if}
				
				{if $LANG.prosper_registerdomain_features_6_heading}
				
					<h4 class="gridboxes1-heading">{$LANG.prosper_registerdomain_features_6_heading}</h4>
				
				{/if}
				
				{if $LANG.prosper_registerdomain_features_6_text}
				
					<div class="gridboxes1-text">
				
						{$LANG.prosper_registerdomain_features_6_text}
					
					</div><!-- .gridboxes1-text -->
				
				{/if}

				{if $LANG.prosper_registerdomain_features_6_button1_url || $LANG.prosper_registerdomain_features_6_button2_url}
					<div class="gridboxes1-buttons">
						{if $LANG.prosper_registerdomain_features_6_button1_url}<a href="{$LANG.prosper_registerdomain_features_6_button1_url}" class="button1 color2"{if $LANG.prosper_registerdomain_features_6_button1_url_newwindow} target="_blank"{/if}>{if $LANG.prosper_registerdomain_features_6_button1_icon}<i class="{$LANG.prosper_registerdomain_features_6_button1_icon}"></i>{/if}{$LANG.prosper_registerdomain_features_6_button1_text}</a>{/if}
						{if $LANG.prosper_registerdomain_features_6_button2_url}<a href="{$LANG.prosper_registerdomain_features_6_button2_url}" class="button1 color2"{if $LANG.prosper_registerdomain_features_6_button2_url_newwindow} target="_blank"{/if}>{if $LANG.prosper_registerdomain_features_6_button2_icon}<i class="{$LANG.prosper_registerdomain_features_6_button2_icon}"></i>{/if}{$LANG.prosper_registerdomain_features_6_button2_text}</a>{/if}							
					</div>
				{/if}					
				
			</div><!-- .gridboxes1-box -->
		
		{/if}
		
		{if $LANG.prosper_registerdomain_features_7_display}
		
			<div class="gridboxes1-box animate__animated animate__fadeInLeft wow{if $LANG.prosper_registerdomain_features_7_displayorder neq 0} displayorder{$LANG.prosper_registerdomain_features_7_displayorder}{/if}">
				
				{if $LANG.prosper_registerdomain_features_7_image}
				
					<div class="gridboxes1-image">
						{if $LANG.prosper_registerdomain_features_7_image_url}<a href="{$LANG.prosper_registerdomain_features_7_image_url}"{if $LANG.prosper_registerdomain_features_7_image_url_newwindow} target="_blank"{/if}>{/if}<img src="{$WEB_ROOT}/templates/{$template}/images/{$LANG.prosper_registerdomain_features_7_image}" alt="{$LANG.prosper_registerdomain_features_7_image_alt}" />{if $LANG.prosper_registerdomain_features_7_image_url}</a>{/if}
					</div>
				
				{/if}
				
				{if $LANG.prosper_registerdomain_features_7_heading}
				
					<h4 class="gridboxes1-heading">{$LANG.prosper_registerdomain_features_7_heading}</h4>
				
				{/if}
				
				{if $LANG.prosper_registerdomain_features_7_text}
				
					<div class="gridboxes1-text">
				
						{$LANG.prosper_registerdomain_features_7_text}
					
					</div><!-- .gridboxes1-text -->
				
				{/if}

				{if $LANG.prosper_registerdomain_features_7_button1_url || $LANG.prosper_registerdomain_features_7_button2_url}
					<div class="gridboxes1-buttons">
						{if $LANG.prosper_registerdomain_features_7_button1_url}<a href="{$LANG.prosper_registerdomain_features_7_button1_url}" class="button1 color2"{if $LANG.prosper_registerdomain_features_7_button1_url_newwindow} target="_blank"{/if}>{if $LANG.prosper_registerdomain_features_7_button1_icon}<i class="{$LANG.prosper_registerdomain_features_7_button1_icon}"></i>{/if}{$LANG.prosper_registerdomain_features_7_button1_text}</a>{/if}
						{if $LANG.prosper_registerdomain_features_7_button2_url}<a href="{$LANG.prosper_registerdomain_features_7_button2_url}" class="button1 color2"{if $LANG.prosper_registerdomain_features_7_button2_url_newwindow} target="_blank"{/if}>{if $LANG.prosper_registerdomain_features_7_button2_icon}<i class="{$LANG.prosper_registerdomain_features_7_button2_icon}"></i>{/if}{$LANG.prosper_registerdomain_features_7_button2_text}</a>{/if}							
					</div>
				{/if}					
				
			</div><!-- .gridboxes1-box -->
		
		{/if}
		
		{if $LANG.prosper_registerdomain_features_8_display}
		
			<div class="gridboxes1-box animate__animated animate__fadeInUp wow{if $LANG.prosper_registerdomain_features_8_displayorder neq 0} displayorder{$LANG.prosper_registerdomain_features_8_displayorder}{/if}">
				
				{if $LANG.prosper_registerdomain_features_8_image}
				
					<div class="gridboxes1-image">
						{if $LANG.prosper_registerdomain_features_8_image_url}<a href="{$LANG.prosper_registerdomain_features_8_image_url}"{if $LANG.prosper_registerdomain_features_8_image_url_newwindow} target="_blank"{/if}>{/if}<img src="{$WEB_ROOT}/templates/{$template}/images/{$LANG.prosper_registerdomain_features_8_image}" alt="{$LANG.prosper_registerdomain_features_8_image_alt}" />{if $LANG.prosper_registerdomain_features_8_image_url}</a>{/if}
					</div>
				
				{/if}
				
				{if $LANG.prosper_registerdomain_features_8_heading}
				
					<h4 class="gridboxes1-heading">{$LANG.prosper_registerdomain_features_8_heading}</h4>
				
				{/if}
				
				{if $LANG.prosper_registerdomain_features_8_text}
				
					<div class="gridboxes1-text">
				
						{$LANG.prosper_registerdomain_features_8_text}
					
					</div><!-- .gridboxes1-text -->
				
				{/if}

				{if $LANG.prosper_registerdomain_features_8_button1_url || $LANG.prosper_registerdomain_features_8_button2_url}
					<div class="gridboxes1-buttons">
						{if $LANG.prosper_registerdomain_features_8_button1_url}<a href="{$LANG.prosper_registerdomain_features_8_button1_url}" class="button1 color2"{if $LANG.prosper_registerdomain_features_8_button1_url_newwindow} target="_blank"{/if}>{if $LANG.prosper_registerdomain_features_8_button1_icon}<i class="{$LANG.prosper_registerdomain_features_8_button1_icon}"></i>{/if}{$LANG.prosper_registerdomain_features_8_button1_text}</a>{/if}
						{if $LANG.prosper_registerdomain_features_8_button2_url}<a href="{$LANG.prosper_registerdomain_features_8_button2_url}" class="button1 color2"{if $LANG.prosper_registerdomain_features_8_button2_url_newwindow} target="_blank"{/if}>{if $LANG.prosper_registerdomain_features_8_button2_icon}<i class="{$LANG.prosper_registerdomain_features_8_button2_icon}"></i>{/if}{$LANG.prosper_registerdomain_features_8_button2_text}</a>{/if}							
					</div>
				{/if}					
				
			</div><!-- .gridboxes1-box -->
		
		{/if}
		
		{if $LANG.prosper_registerdomain_features_9_display}
		
			<div class="gridboxes1-box animate__animated animate__fadeInRight wow{if $LANG.prosper_registerdomain_features_9_displayorder neq 0} displayorder{$LANG.prosper_registerdomain_features_9_displayorder}{/if}">
				
				{if $LANG.prosper_registerdomain_features_9_image}
				
					<div class="gridboxes1-image">
						{if $LANG.prosper_registerdomain_features_9_image_url}<a href="{$LANG.prosper_registerdomain_features_9_image_url}"{if $LANG.prosper_registerdomain_features_9_image_url_newwindow} target="_blank"{/if}>{/if}<img src="{$WEB_ROOT}/templates/{$template}/images/{$LANG.prosper_registerdomain_features_9_image}" alt="{$LANG.prosper_registerdomain_features_9_image_alt}" />{if $LANG.prosper_registerdomain_features_9_image_url}</a>{/if}
					</div>
				
				{/if}
				
				{if $LANG.prosper_registerdomain_features_9_heading}
				
					<h4 class="gridboxes1-heading">{$LANG.prosper_registerdomain_features_9_heading}</h4>
				
				{/if}
				
				{if $LANG.prosper_registerdomain_features_9_text}
				
					<div class="gridboxes1-text">
				
						{$LANG.prosper_registerdomain_features_9_text}
					
					</div><!-- .gridboxes1-text -->
				
				{/if}

				{if $LANG.prosper_registerdomain_features_9_button1_url || $LANG.prosper_registerdomain_features_9_button2_url}
					<div class="gridboxes1-buttons">
						{if $LANG.prosper_registerdomain_features_9_button1_url}<a href="{$LANG.prosper_registerdomain_features_9_button1_url}" class="button1 color2"{if $LANG.prosper_registerdomain_features_9_button1_url_newwindow} target="_blank"{/if}>{if $LANG.prosper_registerdomain_features_9_button1_icon}<i class="{$LANG.prosper_registerdomain_features_9_button1_icon}"></i>{/if}{$LANG.prosper_registerdomain_features_9_button1_text}</a>{/if}
						{if $LANG.prosper_registerdomain_features_9_button2_url}<a href="{$LANG.prosper_registerdomain_features_9_button2_url}" class="button1 color2"{if $LANG.prosper_registerdomain_features_9_button2_url_newwindow} target="_blank"{/if}>{if $LANG.prosper_registerdomain_features_9_button2_icon}<i class="{$LANG.prosper_registerdomain_features_9_button2_icon}"></i>{/if}{$LANG.prosper_registerdomain_features_9_button2_text}</a>{/if}							
					</div>
				{/if}					
				
			</div><!-- .gridboxes1-box -->
		
		{/if}
		
		{if $LANG.prosper_registerdomain_features_10_display}
		
			<div class="gridboxes1-box animate__animated animate__fadeInLeft wow{if $LANG.prosper_registerdomain_features_10_displayorder neq 0} displayorder{$LANG.prosper_registerdomain_features_10_displayorder}{/if}">
				
				{if $LANG.prosper_registerdomain_features_10_image}
				
					<div class="gridboxes1-image">
						{if $LANG.prosper_registerdomain_features_10_image_url}<a href="{$LANG.prosper_registerdomain_features_10_image_url}"{if $LANG.prosper_registerdomain_features_10_image_url_newwindow} target="_blank"{/if}>{/if}<img src="{$WEB_ROOT}/templates/{$template}/images/{$LANG.prosper_registerdomain_features_10_image}" alt="{$LANG.prosper_registerdomain_features_10_image_alt}" />{if $LANG.prosper_registerdomain_features_10_image_url}</a>{/if}
					</div>
				
				{/if}
				
				{if $LANG.prosper_registerdomain_features_10_heading}
				
					<h4 class="gridboxes1-heading">{$LANG.prosper_registerdomain_features_10_heading}</h4>
				
				{/if}
				
				{if $LANG.prosper_registerdomain_features_10_text}
				
					<div class="gridboxes1-text">
				
						{$LANG.prosper_registerdomain_features_10_text}
					
					</div><!-- .gridboxes1-text -->
				
				{/if}

				{if $LANG.prosper_registerdomain_features_10_button1_url || $LANG.prosper_registerdomain_features_10_button2_url}
					<div class="gridboxes1-buttons">
						{if $LANG.prosper_registerdomain_features_10_button1_url}<a href="{$LANG.prosper_registerdomain_features_10_button1_url}" class="button1 color2"{if $LANG.prosper_registerdomain_features_10_button1_url_newwindow} target="_blank"{/if}>{if $LANG.prosper_registerdomain_features_10_button1_icon}<i class="{$LANG.prosper_registerdomain_features_10_button1_icon}"></i>{/if}{$LANG.prosper_registerdomain_features_10_button1_text}</a>{/if}
						{if $LANG.prosper_registerdomain_features_10_button2_url}<a href="{$LANG.prosper_registerdomain_features_10_button2_url}" class="button1 color2"{if $LANG.prosper_registerdomain_features_10_button2_url_newwindow} target="_blank"{/if}>{if $LANG.prosper_registerdomain_features_10_button2_icon}<i class="{$LANG.prosper_registerdomain_features_10_button2_icon}"></i>{/if}{$LANG.prosper_registerdomain_features_10_button2_text}</a>{/if}							
					</div>
				{/if}					
				
			</div><!-- .gridboxes1-box -->
		
		{/if}																											
																																													
	</div><!-- .gridboxes1 -->
	
{/if}